% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-tapereuca2.r
\docType{data}
\name{tapereuca2}
\alias{tapereuca2}
\title{Datos de ahusamiento de Eucalyptus regnans}
\format{
Contiene las siguientes variables:
\describe{
\item{narb}{Número del árbol.}
\item{sec}{Número de sección del árbol \code{narb}.}
\item{hl}{Altura fustal de la sección \code{sec}, en m.}
\item{dlcc}{Diámetro de la sección \code{sec} con corteza, en cm.}
\item{dlsc}{Diámetro de la sección \code{sec} sin corteza, en cm.}
\item{ec}{Espesor de corteza de la sección \code{sec}.}
\item{forma}{Forma del árbol, en donde \code{1} = Fuste cilíndrico y \code{2}
= Fuste acilíndrico (pequeña curvatura).}
\item{dap}{Diámetro a la altura del pecho (1.3 m) en cm.}
\item{decdap}{Doble espesor de corteza en el \code{dap}.}
\item{htot}{Altura total del árbol \code{narb}, en m.}
\item{dtoc}{Diámetro con corteza en \code{hcc}.}
\item{hcc}{Altura de comienzo de copa del árbol \code{narb}, m.}
}
}
\source{
Los datos provienen de la Tesis de Ingeniero Forestal de Manuel
Morales, UFRO.
}
\usage{
data(tapereuca2)
}
\description{
Corresponde a mediciones de diámetros fustales, con y sin corteza,
para árboles muestra en plantaciones de \emph{Eucalyptus regnans} en la
comuna de Gorbea, región de la Araucanía, Chile. Note que existen
por lo tanto, varias mediciones para cada árbol.
}
\examples{
data(tapereuca2)
lattice::xyplot(dlcc~hl, data=tapereuca2, type = "l", groups = narb)
}
\references{
\itemize{
\item Morales, M. (2003). Modelos fustales para \emph{Eucalyptus
regnans} F. Muell., en la comuna de Gorbea, Novena Región. Tesis
Ingeniero Forestal. Universidad de La Frontera. Temuco, Chile. 43p.
}
}
\keyword{datasets}
