% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/site_species_subset.R
\name{site_species_subset}
\alias{site_species_subset}
\title{Extract a subset of sites or species from a \code{bioregion.clusters} object}
\usage{
site_species_subset(clusters, node_type = "site")
}
\arguments{
\item{clusters}{An object of class \code{bioregion.clusters}.}

\item{node_type}{A \code{character} string indicating the type of nodes to
extract. Possible values are \code{"site"} or \code{"species"}. The default is
\code{"site"}.}
}
\value{
An object of class \code{bioregion.clusters} containing only the specified
node type (sites or species).
}
\description{
This function extracts a subset of nodes based on their type (\code{"site"} or
\code{"species"}) from a \code{bioregion.clusters} object, which contains both types of
nodes (sites and species).
}
\note{
Network clustering functions (prefixed with \code{netclu_}) may return both types
of nodes (sites and species) when applied to bipartite networks (using the
\code{bipartite} argument). In such cases, the type of nodes included in the
output can be specified with the \code{return_node_type} argument. This function
allows you to extract a particular type of nodes (sites or species) from the
output and adjust the \code{return_node_type} attribute accordingly.
}
\examples{
net <- data.frame(
  Site = c(rep("A", 2), rep("B", 3), rep("C", 2)),
  Species = c("a", "b", "a", "c", "d", "b", "d"),
  Weight = c(10, 100, 1, 20, 50, 10, 20)
)

clusters <- netclu_louvain(net, lang = "igraph", bipartite = TRUE)

clusters_sites <- site_species_subset(clusters, node_type = "site")

}
\author{
Maxime Lenormand (\email{maxime.lenormand@inrae.fr}) \cr
Pierre Denelle (\email{pierre.denelle@gmail.com}) \cr
Boris Leroy (\email{leroy.boris@gmail.com})
}
