% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bioregion_metrics.R
\name{bioregion_metrics}
\alias{bioregion_metrics}
\title{Calculate contribution metrics for bioregions}
\usage{
bioregion_metrics(bioregionalization, comat, map = NULL, col_bioregion = NULL)
}
\arguments{
\item{bioregionalization}{A \code{bioregion.clusters} object.}

\item{comat}{A co-occurrence \code{matrix} with sites as rows and species as
columns.}

\item{map}{A spatial \verb{sf data.frame} with sites and bioregions. It is the
output of the function \code{map_bioregions}. \code{NULL} by default.}

\item{col_bioregion}{An \code{integer} specifying the column position of the
bioregion.}
}
\value{
A \code{data.frame} with 5 columns, or 6 if spatial coherence is computed.
}
\description{
This function calculates the number of sites per bioregion, as well as the
number of species these sites have, the number of endemic species, and the
proportion of endemism.
}
\details{
Endemic species are species found only in the sites belonging to one
bioregion.
}
\examples{
comat <- matrix(sample(1000, 50), 5, 10)
rownames(comat) <- paste0("Site", 1:5)
colnames(comat) <- paste0("Species", 1:10)

net <- similarity(comat, metric = "Simpson")
clust <- netclu_louvain(net)

bioregion_metrics(bioregionalization = clust, 
                  comat = comat) 

}
\seealso{
For more details illustrated with a practical example,
see the vignette:
\url{https://biorgeo.github.io/bioregion/articles/a5_2_summary_metrics.html}.

Associated functions:
\link{site_species_metrics} \link{bioregionalization_metrics}
}
\author{
Pierre Denelle (\email{pierre.denelle@gmail.com}) \cr
Boris Leroy (\email{leroy.boris@gmail.com}) \cr
Maxime Lenormand (\email{maxime.lenormand@inrae.fr})
}
