% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regmod.R
\name{regmod_prediction}
\alias{regmod_prediction}
\title{regmod_prediction}
\usage{
regmod_prediction(data, xpred)
}
\arguments{
\item{data}{A bregmod object.}

\item{xpred}{A kxp matrix of input values for regressors for prediction, where k is the number of points we do the prediction and p is the dimension of the input variables.}
}
\value{
A kxm array. Qpred(l, :) is the regression prediction of Q given X = xpred(l, :)' where m is the dimension of the grid of quantile function.
}
\description{
Performs the Wasserstein regression using quantile functions.
}
\examples{
# Data extracted from the paper: Hall, H., Perelman, D., Breschi, A., Limcaoco, P., Kellogg, R.,
# McLaughlin, T., Snyder, M., Glucotypes reveal new patterns of glucose dysregulation, PLoS
# biology 16(7), 2018.
file1 = system.file("extdata", "data_1.csv", package = "biosensors.usc")
file2 = system.file("extdata", "variables_1.csv", package = "biosensors.usc")
data = load_data(file1, file2)
regm = regmod_regression(data, "BMI")
# Example of prediction
xpred = as.matrix(25)
g1rmp = regmod_prediction(regm, xpred)
}
