% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clouds.R
\name{density1D}
\alias{density1D}
\title{Creates a kernel density in 1-dimension}
\usage{
density1D(
  bp,
  which = NULL,
  h = "nrd0",
  kernel = "gaussian",
  col = ez.col,
  lwd = 1.5,
  legend.mar = c(2, 5, 0, 5)
)
}
\arguments{
\item{bp}{object of class \code{biplot}}

\item{which}{which group.}

\item{h}{bandwidth.}

\item{kernel}{character string giving the smoothing kernel to be used.}

\item{col}{colours to be used for each of the density curves.}

\item{lwd}{linewidth of density curve.}

\item{legend.mar}{The margin line of the legend.}
}
\value{
An object of class \code{biplot}.
}
\description{
Creates a kernel density in 1-dimension
}
\examples{
biplot (iris,classes=iris[,5]) |> CVA(dim=1) |> density1D() |> plot()
}
