% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general.R
\name{get_bitmex}
\alias{get_bitmex}
\title{GET requests}
\usage{
get_bitmex(path, args = NULL, use_auth = FALSE)
}
\arguments{
\item{path}{string. End point for the api.}

\item{args}{A named list containing valid parameters for the given API endpoint.}

\item{use_auth}{logical. Use \code{TRUE} to access private endpoints
if authentication has been set up}
}
\value{
Returns a \code{data.frame} containing the response from the request.
}
\description{
Use \code{get_bitmex()} to send GET requests. For private endpoints, authentication is required.
}
\examples{
\dontrun{

# Access a public endpoint
chat <- get_bitmex(path = "/chat", args = list(channelID = 1, reverse = "true"))

# Access private endpoint using `use_auth` = `TRUE`.
user <- get_bitmex(path = "/execution", args = list(symbol = "XBTUSD"), use_auth = TRUE)
}

}
\references{
\url{https://www.bitmex.com/api/explorer/}
}
