% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SamplePred.R
\name{SamplePred}
\alias{SamplePred}
\title{Obtain posterior samples of predictions at new points}
\usage{
SamplePred(
  fit,
  Znew = NULL,
  Xnew = NULL,
  Z = NULL,
  X = NULL,
  y = NULL,
  sel = NULL,
  type = c("link", "response"),
  ...
)
}
\arguments{
\item{fit}{An object containing the results returned by a the \code{kmbayes} function}

\item{Znew}{optional matrix of new predictor values at which to predict new \code{h}, where each row represents a new observation. If not specified, defaults to using observed Z values}

\item{Xnew}{optional matrix of new covariate values at which to obtain predictions. If not specified, defaults to using observed X values}

\item{Z}{an \code{n}-by-\code{M} matrix of predictor variables to be included in the \code{h} function. Each row represents an observation and each column represents an predictor.}

\item{X}{an \code{n}-by-\code{K} matrix of covariate data where each row represents an observation and each column represents a covariate. Should not contain an intercept column.}

\item{y}{a vector of outcome data of length \code{n}.}

\item{sel}{A vector selecting which iterations of the BKMR fit should be retained for inference. If not specified, will default to keeping every 10 iterations after dropping the first 50\% of samples, or if this results in fewer than 100 iterations, than 100 iterations are kept}

\item{type}{whether to make predictions on the scale of the link or of the response; only relevant for the binomial outcome family}

\item{...}{other arguments; not currently used}
}
\value{
a matrix with the posterior samples at the new points
}
\description{
Obtains posterior samples of \code{E(Y) = h(Znew) + beta*Xnew} or of \code{g^{-1}[E(y)]}
}
\details{
For guided examples, go to \url{https://jenfb.github.io/bkmr/overview.html}
}
\examples{
set.seed(111)
dat <- SimData(n = 50, M = 4)
y <- dat$y
Z <- dat$Z
X <- dat$X

## Fit model with component-wise variable selection
## Using only 100 iterations to make example run quickly
## Typically should use a large number of iterations for inference
set.seed(111)
fitkm <- kmbayes(y = y, Z = Z, X = X, iter = 100, verbose = FALSE, varsel = TRUE)

med_vals <- apply(Z, 2, median)
Znew <- matrix(med_vals, nrow = 1)
h_true <- dat$HFun(Znew)
set.seed(111)
samps3 <- SamplePred(fitkm, Znew = Znew, Xnew = cbind(0))
head(samps3)
}
