% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyzeGibbs.R
\name{links}
\alias{links}
\title{Function that returns the shared MPMMS
(except with an easier condition to code than JASA paper).
 Function to make a list of vectors of estimated links by "P(MPMMS)>0.5" method
Note: The default settings return only MPMMSs with multiple members.}
\usage{
links(lam.gs = lam.gs, include.singles = FALSE, show.as.multiple = FALSE)
}
\arguments{
\item{lam.gs}{The estimated linkage structure with a default of 10 iterations}

\item{include.singles}{Do not include the singleton records}

\item{show.as.multiple}{Always return MPMMSs that have more than one member}
}
\value{
Returns the shared MPMMS
}
\description{
Function that returns the shared MPMMS
(except with an easier condition to code than JASA paper).
 Function to make a list of vectors of estimated links by "P(MPMMS)>0.5" method
Note: The default settings return only MPMMSs with multiple members.
}
\examples{
lam.gs <- matrix(c(1,1,2,2,3,3,5,6,4,3,4,5,3,2,4,1,2,3,4,2),ncol=20,  nrow=4)
links(lam.gs)
}
