% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arrange.R
\name{new_arrange_block}
\alias{new_arrange_block}
\title{Arrange block constructor}
\usage{
new_arrange_block(columns = character(), ...)
}
\arguments{
\item{columns}{Columns to arrange by. Can be a character vector (ascending order)
or a list of specifications with column and direction.}

\item{...}{Forwarded to \code{\link[blockr.core:new_block]{blockr.core::new_block()}}}
}
\value{
A transform block object of class \code{arrange_block}.
}
\description{
This block allows allows you to order the rows of a data frame by the values
of selected columns (see \code{\link[dplyr:arrange]{dplyr::arrange()}}).
}
\examples{
# Create an arrange block
new_arrange_block(columns = "mpg")

if (interactive()) {
  library(blockr.core)
  library(blockr.dplyr)

  # Basic usage - single column ascending
  serve(new_arrange_block(columns = "mpg"), list(data = mtcars))

  # Multiple columns with custom directions
  serve(
    new_arrange_block(
      columns = list(
        list(column = "cyl", direction = "asc"),
        list(column = "mpg", direction = "desc")
      )
    ),
    list(data = mtcars)
  )

  # Connected blocks - sort after categorizing
  serve(
    new_board(
      blocks = list(
        data = new_dataset_block(dataset = "mtcars"),
        categorized = new_mutate_block(
          exprs = list(
            car_type = paste0(
              "dplyr::case_when(cyl <= 4 ~ 'Economy', ",
              "cyl <= 6 ~ 'Standard', TRUE ~ 'Performance')"
            )
          )
        ),
        sorted = new_arrange_block(
          columns = list(
            list(column = "car_type", direction = "asc"),
            list(column = "mpg", direction = "desc"),
            list(column = "hp", direction = "desc")
          )
        )
      ),
      links = links(
        from = c("data", "categorized"),
        to = c("categorized", "sorted")
      )
    )
  )
}

}
