% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join.R
\name{new_join_block}
\alias{new_join_block}
\title{Join block constructor}
\usage{
new_join_block(type = character(), by = character(), ...)
}
\arguments{
\item{type}{Join type (left_join, inner_join, right_join, full_join, semi_join, anti_join)}

\item{by}{Column(s) to join on - can be character vector for same-name joins
or named list for different-name joins}

\item{...}{Forwarded to \code{\link[blockr.core:new_block]{blockr.core::new_block()}}}
}
\value{
A transform block object of class \code{join_block}.
}
\description{
This block allows for joining of two \code{data.frame} objects with advanced
multi-column support including same-name and different-name joins (see
\code{\link[dplyr:mutate-joins]{dplyr::left_join()}}, \code{\link[dplyr:mutate-joins]{dplyr::inner_join()}}, etc.).
}
\examples{
# Create a join block
new_join_block(type = "left_join")

if (interactive()) {
  library(blockr.core)
  library(blockr.dplyr)

  # Basic left join - automatically detects common columns
  serve(
    new_board(
      blocks = list(
        data1 = new_dataset_block(dataset = "band_members"),
        data2 = new_dataset_block(dataset = "band_instruments"),
        joined = new_join_block(type = "left_join")
      ),
      links = links(
        from = c("data1", "data2"),
        to = c("joined", "joined"),
        input = c("x", "y")
      )
    )
  )

  # Inner join with explicit join column
  serve(
    new_board(
      blocks = list(
        data1 = new_dataset_block(dataset = "band_members"),
        data2 = new_dataset_block(dataset = "band_instruments"),
        joined = new_join_block(type = "inner_join", by = "name")
      ),
      links = links(
        from = c("data1", "data2"),
        to = c("joined", "joined"),
        input = c("x", "y")
      )
    )
  )

  # Right join - keep all rows from right dataset
  serve(
    new_board(
      blocks = list(
        data1 = new_dataset_block(dataset = "band_members"),
        data2 = new_dataset_block(dataset = "band_instruments"),
        joined = new_join_block(type = "right_join")
      ),
      links = links(
        from = c("data1", "data2"),
        to = c("joined", "joined"),
        input = c("x", "y")
      )
    )
  )

  # Anti join - find rows in left without matches in right
  serve(
    new_board(
      blocks = list(
        data1 = new_dataset_block(dataset = "band_members"),
        data2 = new_dataset_block(dataset = "band_instruments"),
        joined = new_join_block(type = "anti_join")
      ),
      links = links(
        from = c("data1", "data2"),
        to = c("joined", "joined"),
        input = c("x", "y")
      )
    )
  )
}

}
