% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{vb_plot}
\alias{vb_plot}
\title{Plot the summary of a voting bloc analysis}
\usage{
vb_plot(
  data,
  x_col = get_bloc_var(data),
  y_col,
  ymin_col,
  ymax_col,
  discrete = length(unique(data[[x_col]])) < 20
)
}
\arguments{
\item{data}{a \code{vbsum} data.frame, the result of [vb_summary].}

\item{x_col}{string naming the column that defines voting blocs.}

\item{y_col}{string naming the column of point estimates.}

\item{ymin_col}{string naming the column to plot as the lower bound of the confidence interval.}

\item{ymax_col}{string naming the column to plot as the upper bound of the confidence interval.}

\item{discrete}{logical indicating whether voting blocs are defined along a discrete (not continuous) variable.}
}
\value{
a ggplot object
}
\description{
Plot the summary of a voting bloc analysis
}
