% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/county_fips.R, R/data.R
\docType{data}
\name{county_fips}
\alias{county_fips}
\title{Return a dataframe of county FIPS codes by state.}
\format{
A data frame with 3235 rows and 5 variables
}
\usage{
county_fips(state, ...)

data(county_fips)
}
\arguments{
\item{state}{= A string containing a standard state short abbreviation, i.e. FL, WA, OH, etc.}

\item{...}{additional arguments}
}
\value{
A tibble from the BLS API.
}
\description{
Returns a data frame that uses data from the US Census FIPS code list.

Built-in dataset for use with the \code{bls_map} function.
To access the data directly, issue the command \code{datacounty_fips)}.
\itemize{
  \item \code{state}: State name
  \item \code{fips_state}: FIPS code for State
  \item \code{fips_county}: FIPS code for County
  \item \code{county}: County name
  \item \code{type}: type
}
}
\note{
Last updated 2024-03-13
}
\examples{
\dontrun{
## Get historical USD values based on a 2010 dollar.
values <- county_fips(state = "FL")
}

}
\keyword{internal}
