% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/global_monitor.R
\name{global_monitor}
\alias{global_monitor}
\title{Global monitor}
\usage{
global_monitor(dag, df, alpha = "default")
}
\arguments{
\item{dag}{an object of class \code{bn} from the \code{bnlearn} package}

\item{df}{a base R style dataframe}

\item{alpha}{single integer. By default, number of max levels in \code{df}}
}
\value{
A numerical value
}
\description{
Negative marginal log-likelihood of the model
}
\examples{
global_monitor(chds_bn, chds, 3)

}
\references{
Cowell, R. G., Dawid, P., Lauritzen, S. L., & Spiegelhalter, D. J. (2006). Probabilistic networks and expert systems: Exact computational methods for Bayesian networks. Springer Science & Business Media.

Cowell, R. G., Verrall, R. J., & Yoon, Y. K. (2007). Modeling operational risk with Bayesian networks. Journal of Risk and Insurance, 74(4), 795-827.
}
\seealso{
\code{\link{node_monitor}}, \code{\link{influential_obs}}, \code{\link{final_node_monitor}}, \code{\link{seq_node_monitor}}, \code{\link{seq_pa_ch_monitor}}
}
