% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dwi.R
\name{dwi}
\alias{dwi}
\title{Distance-weigthed influence}
\usage{
dwi(bn, node, w)
}
\arguments{
\item{bn}{object of class \code{bn.fit} or \code{bn}.}

\item{node}{a node of \code{bnfit}.}

\item{w}{a number in \eqn{(0,1]}.}
}
\value{
A dataframe with the following columns: \code{Nodes} - the vertices of the BN; \code{Influence} - the distance-weigthed influence of the corresponding node.
}
\description{
Computation of the distance-weigthed influence in a Bayesian network
}
\details{
The distance-weigthed influence of a node \eqn{X_j} on an output node \eqn{X_i} in a Bayesian network is \deqn{DWI(X_j,X_i,w)= \sum_{s\in S_{ji}}w^{|s|},} where \eqn{S_{ji}} is the set of active trails between \eqn{X_j} and \eqn{X_i}, \eqn{w\in(0,1]} is an input parameter, and \eqn{|s|} is the length of the trail \eqn{s}.
}
\examples{
dwi(travel, "T", 0.5)

}
\references{
Albrecht, D., Nicholson, A. E., & Whittle, C. (2014). Structural sensitivity for the knowledge engineering of Bayesian networks. In Probabilistic Graphical Models (pp. 1-16). Springer International Publishing.
}
\seealso{
\code{\link{ewi}}, \code{\link{mutual_info}}
}
