% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/21_earZcbVariousPeriodicity.R
\name{earZcbVariousPeriodicity}
\alias{earZcbVariousPeriodicity}
\title{Calculates Effective Annual Rate (EAR) of a Zero-Coupon Bond for various values of Periodicity.}
\usage{
earZcbVariousPeriodicity(
  maturityVal,
  yearsToMaturity,
  ZCBprice,
  desiredPeriodicity
)
}
\arguments{
\item{maturityVal}{A number.}

\item{yearsToMaturity}{A number.}

\item{ZCBprice}{A number.}

\item{desiredPeriodicity}{A number.}
}
\value{
Input values to four arguments  \code{maturityVal} , \code{yearsToMaturity},\code{ZCBprice} and  \code{desiredPeriodicity}.
}
\description{
Calculates Effective Annual Rate (EAR) of a Zero-Coupon Bond for various values of Periodicity.
}
\details{
This method, \code{earZcbVariousPeriodicity()} is developed to compute an Effective Annual Rate (EAR) of a Zero-Coupon Bond for various values of Periodicity, for the values passed to its four arguments. Here, \code{maturityVal} is Maturity Value of the Bond, \code{yearsToMaturity} represents years to maturity, \code{ZCBprice} represents price of Zero-Coupon Bond, and \code{desiredPeriodicity} desired periodicity for which the Effective Annual Rate is to be computed. The output is rounded off to six decimal places.
}
\examples{
earZcbVariousPeriodicity(maturityVal=100, yearsToMaturity=5, ZCBprice=80, desiredPeriodicity=1)
earZcbVariousPeriodicity(maturityVal=100, yearsToMaturity=5, ZCBprice=80, desiredPeriodicity=12)
earZcbVariousPeriodicity(maturityVal=100, yearsToMaturity=5, ZCBprice=80, desiredPeriodicity=4)
earZcbVariousPeriodicity(maturityVal=100, yearsToMaturity=5, ZCBprice=80, desiredPeriodicity=2)
}
\references{
Adams,J.F. & Smith,D.J.(2019). Introduction to fixed-income valuation. In CFA Program Curriculum 2020 Level I Volumes 1-6. (Vol. 5, pp. 107-151). Wiley Professional Development (P&T). ISBN 9781119593577, \url{https://bookshelf.vitalsource.com/books/9781119593577}
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
