% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/para.boot.R
\name{para.boot}
\alias{para.boot}
\title{Parametric Bootstrap for i.i.d. Data}
\usage{
para.boot(X, func, rdist, param, B = 999, ...)
}
\arguments{
\item{X}{A numeric vector representing the data.}

\item{func}{A function taking \code{X} as an argument,
representing the statistic of interest to be bootstrapped.
It should returns a vector of size \code{p >= 1}.}

\item{rdist}{A parametric distribution generator that produces bootstrap data based on the
data size and \code{param}. It should be a function with two arguments
\code{n} - the size of the bootstrap sample and \code{par} - a vector
of the parameters.}

\item{param}{Numeric vector. Values of parameters used to generate the bootstrap data.
These can be either the true parameter values for Monte Carlo approximation of the
true distribution, or the estimated parameters, typically obtained by the
maximum likelihood method.}

\item{B}{A positive integer; the number of bootstrap replications. By default it is 999.}

\item{...}{Optional additional arguments for the \code{func} function.}
}
\value{
A \code{boodd} object containing:
\itemize{
\item \code{s}: Matrix of bootstrap replicates of \code{func}, with dimensions \code{B x p}.
\item \code{Tn}: Vector of \code{func} evaluated on the original data \code{X}.
}
}
\description{
This function performs a parametric bootstrap, a technique that resamples
data based on an assumed distribution with estimated parameter,
rather than resampling the original data directly.
}
\details{
\code{para.boot} is a flexible function for bootstrapping a specified
function \code{func} using a parametric distribution \code{rdist} generated
with estimated or true parameters \code{param}. The function returns a \code{boodd}
object containing the values of the function over all bootstrap samples and
the statistic computed over the original sample.
}
\examples{
rn<-function(n,par) {rnorm(n,mean=par[1],sd=par[2])}
set.seed(5)
# Parametric bootstrap of the mean in a gaussian family
X=rnorm(n=100,mean=2,sd=1)
# simulate distribution with true parameter values (and a Monte-Carlo size 9999
true1<-para.boot(X,mean,rn,param=c(2,1),B=9999)
pb1<-para.boot(X,mean,rn,param=c(mean(X),sd(X)))
plot(pb1)
lines(density(true1$s),col="red")
confint(true1,method="bperc")
confint(pb1, method="all")

}
\references{
Bertail, P. and Dudek, A. (2025). \emph{Bootstrap for
Dependent Data, with an R package} (by Bernard Desgraupes and Karolina Marek) - submitted..

Efron, B., Tibshirani, R. (1993).
\emph{An Introduction to the Bootstrap}, Chapman and Hall.
}
\seealso{
\code{\link{bootglm}}, \code{\link{boots}}.
}
\keyword{"Monte}
\keyword{"Parametric}
\keyword{Carlo}
\keyword{bootstrap"}
\keyword{simulation"}
