% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.boodd.R
\name{plot.boodd}
\alias{plot.boodd}
\title{Plot an Object of Class \code{boodd}}
\usage{
\method{plot}{boodd}(x, with.density = TRUE, which, byrow = FALSE, ...)
}
\arguments{
\item{x}{An object of class \code{boodd}.}

\item{with.density}{Logical value indicating whether to plot the estimated density
of the bootstrap distribution (default is TRUE).}

\item{which}{Specifies which columns of the data to plot.}

\item{byrow}{Logical value indicating whether to display the matrix of
histograms by row. By default it is \code{FALSE}.}

\item{...}{Optional additional arguments for the \code{plot} function.}
}
\value{
The function returns an invisible list containing the output of the
\code{hist} function.
In the case of multiple histograms, it returns a list of lists.
}
\description{
Plots histograms or density estimates for objects of class \code{boodd},
which are returned by bootstrap functions such as boots,
\code{\link{bootsemi}}, \code{\link{blockboot}}, \code{\link{regenboot}}, etc.
}
\details{
The function \code{plot.boodd} plots histograms or density estimates of
the output data contained in an object of class \code{boodd}. When the data have
more than one column, the function can display a matrix of (at most 6) histograms.
The argument \code{which} allows the selection of specific columns to plot,
while \code{byrow} controls the layout of the matrix display.
}
\examples{
B <- 299
x <- round(rnorm(15),3)
boo1 <- boots(x, mean, B)
plot(boo1)

# Bootstrap of several statistics 
mv <- function(data) {c(mean(data), var(data))} # compute both mean and variance
boo2 <- boots(x, mv, B)
plot(boo2)
}
\references{
Bertail, P. and Dudek, A. (2025). \emph{Bootstrap for
Dependent Data, with an R package} (by Bernard Desgraupes and Karolina Marek) - submitted.

Efron, B., Tibshirani, R. (1993).
\emph{An Introduction to the Bootstrap}, Chapman and Hall.
}
\seealso{
\code{\link{confint.boodd}}, \code{\link{summary.boodd}}, \code{\link{class.boodd}}.
}
\keyword{"Bootstrap}
\keyword{Plotting}
\keyword{distribution"}
