% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thetaRB.R
\name{thetaRB}
\alias{thetaRB}
\title{Compute the Extremal Index for Atomic Markov Chains Using Regenerative
Blocks}
\usage{
thetaRB(X, ato)
}
\arguments{
\item{X}{A numeric vector representing the Markov chain.}

\item{ato}{A numeric value; the atom of the Markov chain.}
}
\value{
A numeric vector representing the extremal index at various quantile thresholds.
}
\description{
This function divides the input dataset into blocks for an
atomic Markov chain and calculates the extremal index using quantile-based thresholds.
}
\details{
The function uses \code{GetBlocks} to divide \code{X} into blocks
according to the atom \code{ato}.
High quantiles from \code{X} are generated and used as thresholds to compute
statistics on each block, including sub-maximums
and block indices. These statistics are then used to calculate the extremal index,
a measure of extreme value clustering, across the blocks.
}
\examples{
X = genMM1(1000, 1, 2)
thetaB <- thetaRB(X, ato=0)
plot(thetaB)
}
\references{
Bertail, P. and Dudek, A. (2025). \emph{Bootstrap for
Dependent Data, with an R package} (by Bernard Desgraupes and Karolina Marek) - submitted.

Bertail, P. and Clémençon, S. (2006).
Regeneration-based statistics for Harris recurrent
Markov chains.
\emph{Lecture notes in Statistics}, vol. \bold{187}, pp. 1-54, Springer.

Bertail, P., Clémençon, S. and Tressou, J. (2009). Extreme values statistics for Markov chains
via the (pseudo-) regenerative method. \emph{Extremes}, \bold{12}, 327–360.
}
\seealso{
\code{\link{GetBlocks}},
\code{\link{regenboot}}.
}
\keyword{"Atom"}
\keyword{"Extremal}
\keyword{"Markov}
\keyword{"Regenerative}
\keyword{Block"}
\keyword{chains"}
\keyword{index"}
