% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.R
\name{cvrisk.boostrq}
\alias{cvrisk.boostrq}
\title{Crossvalidation for boostrq}
\usage{
\method{cvrisk}{boostrq}(
  object,
  folds = mboost::cv(object$weights, type = "kfold"),
  grid = 0:mstop(object),
  papply = parallel::mclapply,
  mc.preschedule = FALSE,
  fun = NULL,
  ...
)
}
\arguments{
\item{object}{a boostrq object}

\item{folds}{a matrix indicating the weights for the k resampling iterations}

\item{grid}{a vetor of stopping parameters the empirical quantile risk is to be evaluated for.}

\item{papply}{(parallel) apply function, defaults to mclapply. To run sequentially
(i.e. not in parallel), one can use lapply.}

\item{mc.preschedule}{preschedule tasks if are parallelized using mclapply (default: FALSE)?
For details see mclapply.}

\item{fun}{if fun is NULL, the out-of-sample risk is returned. fun, as a function of object, may
extract any other characteristic of the cross-validated models. These are returned as is.}

\item{...}{additional arguments passed to callies}
}
\value{
Cross-validated Boosting regression quantiles
}
\description{
Crossvalidation for boostrq
}
\examples{
boosted.rq <-
boostrq(
 formula = mpg ~ brq(cyl * hp) + brq(am + wt),
 data = mtcars,
 mstop = 200,
 nu = 0.1,
 tau = 0.5
)

set.seed(101)

cvk.out <-
cvrisk(
 boosted.rq,
 grid = 0:mstop(boosted.rq),
 folds = mboost::cv(boosted.rq$weights, type = "kfold", B = 5)
)

cvk.out

plot(cvk.out)

mstop(cvk.out)

boosted.rq[mstop(cvk.out)]

}
