% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ORI.R
\name{logMargLikeOR1}
\alias{logMargLikeOR1}
\title{Marginal likelihood in the OR1 model}
\usage{
logMargLikeOR1(y, x, b0, B0, d0, D0, postMeanbeta,
postMeandelta, betadraws, deltadraws, tune, Dhat, p, verbose)
}
\arguments{
\item{y}{observed ordinal outcomes, column vector of size \eqn{(n x 1)}.}

\item{x}{covariate matrix of size \eqn{(n x k)} including a column of ones with or without column names.}

\item{b0}{prior mean for \eqn{\beta}.}

\item{B0}{prior covariance matrix for \eqn{\beta}}

\item{d0}{prior mean for \eqn{\delta}.}

\item{D0}{prior covariance matrix for \eqn{\delta}.}

\item{postMeanbeta}{posterior mean of \eqn{\beta} from the complete MCMC run.}

\item{postMeandelta}{posterior mean of \eqn{\delta} from the complete MCMC run.}

\item{betadraws}{a dataframe with all the sampled values for \eqn{\beta} from the complete MCMC run.}

\item{deltadraws}{a dataframe with all the sampled values for \eqn{\delta} from the complete MCMC run.}

\item{tune}{tuning parameter to adjust the MH acceptance rate.}

\item{Dhat}{negative inverse Hessian from the maximization of log-likelihood.}

\item{p}{quantile level or skewness parameter, p in (0,1).}

\item{verbose}{whether to print the final output and provide additional information or not, default is TRUE.}
}
\value{
Returns an estimate of log marginal likelihood
}
\description{
This function computes the logarithm of marginal likelihood in the OR1 model (ordinal
quantile model with 3 or more outcomes) using the MCMC outputs from the
complete and reduced runs.
}
\details{
This function computes the logarithm of marginal likelihood in the OR1 model using the MCMC outputs from complete and
reduced runs.
}
\examples{
set.seed(101)
data("data25j4")
y <- data25j4$y
xMat <- data25j4$x
k <- dim(xMat)[2]
J <- dim(as.array(unique(y)))[1]
b0 <- array(rep(0, k), dim = c(k, 1))
B0 <- 10*diag(k)
d0 <- array(0, dim = c(J-2, 1))
D0 <- 0.25*diag(J - 2)
output <- quantregOR1(y = y, x = xMat, b0, B0, d0, D0,
burn = 10, mcmc = 40, p = 0.25, tune = 1, accutoff = 0.5, maxlags = 400, verbose = FALSE)
# output$logMargLike
#   -559.73

}
\references{
Chib, S. (1995). `"Marginal likelihood from the Gibbs output."` Journal of the American
Statistical Association, 90(432):1313 to 1321, 1995. DOI: 10.1080/01621459.1995.10476635

Chib, S., and Jeliazkov, I. (2001). `"Marginal likelihood from the Metropolis-Hastings output."` Journal of the
American Statistical Association, 96(453):270`-`281, 2001. DOI: 10.1198/016214501750332848
}
\seealso{
\link[NPflow]{mvnpdf}, \link[stats]{dnorm},
Gibbs sampling, Metropolis-Hastings algorithm
}
