% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_brand.R
\name{get_brand_font}
\alias{get_brand_font}
\title{Get brand fonts/typefaces}
\usage{
get_brand_font(font)
}
\arguments{
\item{font}{A \code{\link[base:character]{character}} vector indicating the name of
fonts/typefaces categories present in the \code{typography} section of the
\verb{_brand.yml} file.}
}
\value{
A \code{\link[base:character]{character}} vector with fonts/typeface names.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#maturing}{\figure{lifecycle-maturing.svg}{options: alt='[Maturing]'}}}{\strong{[Maturing]}}

\code{get_brand_font()} retrieves the names of fonts/typefaces in the
\verb{_brand.yml} file.
}
\details{
\subsection{Path to \verb{_brand.yml}}{

\code{brandr} will always look for a \verb{_brand.yml} file in the root directory of
your project. If the file is not found, an error message will be displayed.
You can also set the path to the file manually using the
\code{\link[base:options]{options()}} function:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{options(BRANDR_BRAND_YML = "PATH_TO_BRAND.YML")
}\if{html}{\out{</div>}}
}
}
\examples{
get_brand_font("base")
#> [1] "Open Sans" # Expected

get_brand_font("headings")
#> [1] "Rubik" # Expected

get_brand_font("monospace")
#> [1] "IBM Plex Mono" # Expected

get_brand_font("monospace-block")
#> [1] "IBM Plex Mono" # Expected

get_brand_font(c("base", "headings"))
#> [1] "Open Sans" "Rubik" # Expected
}
\seealso{
Other utility functions: 
\code{\link{get_brand_color}()},
\code{\link{get_brand_color_mix}()},
\code{\link{get_brand_color_tint}()}
}
\concept{utility functions}
