% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.R
\name{bratteliGraph}
\alias{bratteliGraph}
\title{LaTeX code drawing a Bratteli graph}
\usage{
bratteliGraph(
  outfile,
  Mn,
  N,
  edgelabels = NA,
  vertexlabels = "colnames",
  colorpath = NA,
  rootlabel = "\\\\varnothing",
  latex = TRUE,
  xscale = 50,
  yscale = 50,
  bending = 1,
  hor = FALSE,
  mirror = FALSE,
  northsouth = FALSE
)
}
\arguments{
\item{outfile}{path to the output file}

\item{Mn}{a function returning for each integer \code{n} the incidence
matrix between levels \code{n} and \code{n+1}; the matrix \code{Mn(0)}
must have one and only one row}

\item{N}{the level up to which the graph is wanted}

\item{edgelabels}{\code{"default"}, \code{"letters"}, \code{"order"},
\code{"kernels"}, \code{NA}, or a \emph{vectorized} function with
four arguments: the level of the graph, the index of the "from" vertex,
the index of the "to" vertex, and the index of the edge among the
multiple edges, if there are multiple edges}

\item{vertexlabels}{\code{"colnames"} to use the column names of the
matrices, \code{"dims"} to use the dimensions of the vertices, \code{NA},
or a function with one argument, the level of the graph, returning
for level \code{n} the vector of labels at the \code{n}-th level}

\item{colorpath}{an index of a path to be colored, or \code{NA}}

\item{rootlabel}{a label for the root vertex of the graph}

\item{latex}{Boolean, whether to enclose all labels between dollars}

\item{xscale, yscale}{scaling factors for the graph}

\item{bending}{curvature when there are multiple edges}

\item{hor}{Boolean, whether to render a horizontal graph}

\item{mirror}{Boolean, whether to "reverse" the graph}

\item{northsouth}{Boolean, whether to draw the edges with endpoints at the
bottom and the top of the vertex labels}
}
\value{
No return value; called to generate the LaTeX file.
}
\description{
Generate a LaTeX file containing TikZ code that renders a
  picture of a Bratteli graph.
}
