% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reporting.R
\name{BridgeReport}
\alias{BridgeReport}
\title{Shinyapp reporting for drawing RNA decay curve.}
\usage{
BridgeReport(inputFile, group = c("Control", "Knockdown"), hour = c(0, 1, 2,
  4, 8, 12), comparisonFile = c("Control", "Knockdown"),
  searchRowName = "symbol", inforColumn = 4, color = c("black", "red"),
  TimePointRemoval1 = c(1, 2), TimePointRemoval2 = c(8, 12))
}
\arguments{
\item{inputFile}{The vector of tab-delimited matrix file.}

\item{group}{The vector of group names.}

\item{hour}{The vector of time course about BRIC-seq experiment.}

\item{comparisonFile}{The vector of group names.}

\item{searchRowName}{Row name for searching.}

\item{inforColumn}{The number of information columns.}

\item{color}{color of line graph for two decay curve.}

\item{TimePointRemoval1}{The candicate_1 of time point removal.}

\item{TimePointRemoval2}{The candicate_2 of time point removal.}
}
\value{
shiny.appobj object for searching and showing RNA decay curve for each gene.
}
\description{
\code{BridgeReport} returns a shinyapp object to draw RNA decay curve.
You can easily check RNA half-life and RNA decay fitting curve on
your web browser.
}
\examples{
library(data.table)
normalized_rpkm_matrix <- data.table(gr_id = c(8, 9, 14),
                                     symbol = c("AAAS", "AACS", "AADAT"),
                                     accession_id = c("NM_015665", "NM_023928", "NM_182662"),
                                     locus = c("chr12", "chr12", "chr4"),
                                     CTRL_1_0h = c(1.00, 1.00, 1.00),
                                     CTRL_1_1h = c(1.00, 0.86, 0.96),
                                     CTRL_1_2h = c(1.00, 0.96, 0.88),
                                     CTRL_1_4h = c(1.00, 0.74, 0.85),
                                     CTRL_1_8h = c(1.00, 0.86, 0.68),
                                     CTRL_1_12h = c(1.01, 0.65, 0.60),
                                     gr_id = c(8, 9, 14),
                                     symbol = c("AAAS", "AACS", "AADAT"),
                                     accession_id = c("NM_015665", "NM_023928", "NM_182662"),
                                     locus = c("chr12", "chr12", "chr4"),
                                     KD_1_0h = c(1.00, 1.00, 1.00),
                                     KD_1_1h = c(1.01, 0.73, 0.71),
                                     KD_1_2h = c(1.01, 0.77, 0.69),
                                     KD_1_4h = c(1.01, 0.72, 0.67),
                                     KD_1_8h = c(1.01, 0.64, 0.38),
                                     KD_1_12h = c(1.00, 0.89, 0.63))
group <- c("Control", "Knockdown")
hour <- c(0, 1, 2, 4, 8, 12)
halflife_table <- BridgeRHalfLifeCalcR2Select(normalized_rpkm_matrix,
                                              group = group,
                                              hour = hour,
                                              save = FALSE)
pvalue_table <- BridgeRPvalueEvaluation(halflife_table,
                                        save = FALSE)
shiny_test <- BridgeReport(pvalue_table)

}

