% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convo_update_all_read.R
\name{bs_update_all_read}
\alias{bs_update_all_read}
\title{Mark all conversations as read for the authenticated user}
\usage{
bs_update_all_read(
  status = c("accepted", "request"),
  user = get_bluesky_user(),
  pass = get_bluesky_pass(),
  auth = bs_auth(user, pass),
  clean = TRUE
)
}
\arguments{
\item{status}{Character, length 1. Conversation status, one of  \code{c("accepted", "request")}. Default: \code{NULL}.}

\item{user}{Character. User name to log in with. Defaults to \code{get_bluesky_user()}.}

\item{pass}{Character. App password to log in with. Defaults to \code{get_bluesky_pass()}.}

\item{auth}{Authentication information. Defaults to \code{bs_auth(user, pass)}.}

\item{clean}{Logical. Should output be cleaned into a \code{tibble}? Default: \code{TRUE}.}
}
\value{
a \link[tibble:tibble]{tibble::tibble} or a \code{list} if \code{clean = FALSE}
}
\description{
Mark all conversations as read for the authenticated user
}
\section{Lexicon references}{

\href{https://github.com/bluesky-social/atproto/blob/main/lexicons/chat/bsky/convo/updateAllRead.json}{chat.bsky.convo.updateAllRead.json (2025-05-16)}
}

\section{Function introduced}{

\code{v0.4.0} (2025-05-16)
}

\examples{
\dontshow{if (has_bluesky_pass() && has_bluesky_user()) withAutoprint(\{ # examplesIf}
bs_update_all_read()
\dontshow{\}) # examplesIf}
}
\concept{chat}
