% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_tau.R
\name{.plot_tau}
\alias{.plot_tau}
\title{Plot Treatment Effect Estimate}
\usage{
.plot_tau(data, x, y, ymin, ymax, xintercept, facet, id, subset = NULL)
}
\arguments{
\item{data}{A data frame containing the data to be plotted.}

\item{x}{The name of the x-axis variable (typically the time period) (as a string).}

\item{y}{The name of the y-axis variable (typically the treatment effect) (as a string).}

\item{ymin}{The name of the variable containing the lower bound of the confidence interval (as a string).}

\item{ymax}{The name of the variable containing the upper bound of the confidence interval (as a string).}

\item{xintercept}{The time point of the intervention to be marked with a vertical dashed line.}

\item{facet}{(Optional) The name of the variable to facet the plot by (as a string).}

\item{id}{The name of the variable identifying the units (as a string).}

\item{subset}{(Optional) A vector specifying a subset of units to include in the plot. If NULL, all units are included.}
}
\value{
A ggplot object displaying the treatment effect plot.
}
\description{
This internal helper function creates a plot to visualize the estimated
treatment effect over time. It allows for faceting by a specified variable
and optional subsetting of units to include in the plot.
}
