% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_year}
\alias{get_year}
\title{Extract \code{fhx} observations for given years}
\usage{
get_year(x, yr)
}
\arguments{
\item{x}{An \code{fhx} object.}

\item{yr}{Numeric vector of year(s) to extract from \code{x}.}
}
\value{
An \code{fhx} object.
}
\description{
Extract \code{fhx} observations for given years
}
\examples{
data(lgr2)
get_year(lgr2, 1806)

get_year(lgr2, 1805:1807)

\dontrun{
# Subsetting before/after a specific year requires a
# call to year_range(). For example, to extract all observations
# prior to 1900, use
get_year(lgr2, year_range(lgr2)[1]:1900)
}

}
\seealso{
\itemize{
\item \code{\link[=year_range]{year_range()}} get earliest and latest year in an \code{fhx} object.
\item \code{\link[=get_series]{get_series()}} subset an \code{fhx} object to select series.
\item \code{\link[=delete]{delete()}} remove observations from an \code{fhx} object.
\item \code{\link[=get_event_years]{get_event_years()}} gets years for various events in an \code{fhx} object.
}
}
