% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_staff.R
\name{calc_staff}
\alias{calc_staff}
\title{Calculate the number of staff persons necessary to complete a task}
\usage{
calc_staff(
  task,
  workdays = 205,
  hours = 8,
  rnd = 0.25,
  boom_months = 6,
  boom_pct = 0.5
)
}
\arguments{
\item{task}{The total number of hours to get done in one year.}

\item{workdays}{Numeric, average total working days for a staff person. 205 is the 
conservative lower end for Germany,
      see \url{https://www.deutschlandinzahlen.de/tab/deutschland/arbeitsmarkt/arbeitszeit/arbeitstage}.}

\item{hours}{Number of hours per working day.}

\item{rnd}{Round numbers up to this next fraction of a part-time job.}

\item{boom_months}{Number of months with highest workload, e.g., festival summer}

\item{boom_pct}{Total fraction of \code{task} that needs to be done during \code{boom_months}.}
}
\value{
A named vector with two elements,
      \code{high} (number of staff needed for months with higher workload)
and \code{low} (number of staff needed for months with lower workload).
}
\description{
Calculates two values (split by 'boom_months') and returns both in a vector,
so that there's never a shortage of staff.
}
\details{
Set \code{boom_months=6} and \code{boom_pct=.5} to get all hours spread evenly across the year.
}
\examples{
calc_staff(12328)
}
