% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrar-gradient.R
\name{gradient}
\alias{gradient}
\title{Numerical computation of the gradient, with parallel capabilities}
\usage{
gradient(fn, x, method, control, parallel, ...)
}
\arguments{
\item{fn}{The function to calculate the gradient.}

\item{x}{The value to compute the gradient at.}

\item{method}{The method used. Currently implemented: central, backward, forward and Richardson. See details.}

\item{control}{A list of control arguments.}

\item{parallel}{Boolean, should numerical derivatives be calculated in parallel?}

\item{...}{Additional arguments to be passed to \code{fn}.}
}
\value{
The gradient of \code{fn} at \code{x}.
}
\description{
This function calculates the gradient of a function, numerically, including the possibility
of doing it in parallel.
}
\examples{
gradient(fn=function(x) sum(x^3), x=0)
}
