% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/call.detect.R
\name{call.detect}
\alias{call.detect}
\title{call.detect}
\usage{
call.detect(wave, threshold = 0.3, msmooth = c(500, 95), plot_it = FALSE)
}
\arguments{
\item{wave}{wave object, e.g., from `load.wave` or `readWave`.}

\item{threshold}{rector of length 1 or 2. The fraction of the maximum of the
normalised envelope to use as threshold to detect start and end. If a vector
of length 2 is supplied, the first is used to detect the start and the
second to detect the end (in case of echo).}

\item{msmooth}{used as argument for the `seewave::env` function. *A vector
of length 2 to smooth the amplitude envelope with a mean sliding window. The
first component is the window length (in number of points). The second
component is the overlap between successive windows (in \%).* Default is
`c(500, 95)`.}

\item{plot_it}{if `TRUE`, returns three-panel plot of wave form, envelope
and spectrogram to current plotting window. Default is `FALSE`.}
}
\value{
Returns a dataframe with start = start time in samples and end = end
time in samples for each detection. Optionally also plots the wave form and
detections to current window.
}
\description{
Detects single call in a wave object using an amplitude
envelope.
}
\examples{
require(callsync)
require(seewave)
require(tuneR)
path_git = 'https://raw.githubusercontent.com'
path_repo = '/simeonqs/callsync/master/tests/testthat/files'
file_1 = '/wave_1.wav'
url_1 = paste0(path_git, path_repo, file_1)
local_file_1 = paste(tempdir(), file_1, sep = '/')
if(!file.exists(local_file_1))
  download.file(url_1, destfile = local_file_1, mode = 'wb',)
wave = readWave(local_file_1)
cd = call.detect(wave)

}
