% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_record.R
\name{gg_record}
\alias{gg_record}
\alias{gg_playback}
\alias{gg_resize_film}
\alias{gg_stop_recording}
\title{Record and generate plot histories}
\usage{
gg_record(
  dir = NULL,
  device = c("png", "pdf", "jpeg", "bmp", "tiff", "emf", "svg", "eps", "ps"),
  scale = 1,
  width = NA,
  height = NA,
  units = c("in", "cm", "mm", "px"),
  dpi = 300,
  limitsize = TRUE,
  device_ext = NULL,
  bg = NULL
)

gg_playback(
  name = NULL,
  first_image_duration = 16,
  last_image_duration = 20,
  frame_duration = 0.25,
  loop = TRUE,
  image_resize = 600,
  background = "black",
  width = NULL,
  height = NULL,
  progress = interactive(),
  playback = TRUE,
  stoprecording = FALSE,
  last_as_first = TRUE,
  ...
)

gg_resize_film(height = NA, width = NA, units = NA, dpi = NA)

gg_stop_recording()
}
\arguments{
\item{dir}{directory to save the intermediate plots in. Defaults to a temporary directory}

\item{device}{Device to use. Can either be a device function (e.g. png()), or
one of "png", "pdf", "jpeg", "bmp", "tiff", "emf", "svg", "eps", "ps".}

\item{scale}{Multiplicative scaling factor.}

\item{width, height, units}{Plot size in \code{units} ("in", "cm", "mm", or "px").
If not supplied, uses the size of current graphics device.}

\item{dpi}{Plot resolution. Also accepts a string input: "retina" (320),
"print" (300), or "screen" (72). Applies only to raster output types.}

\item{limitsize}{When \code{TRUE} (the default), \code{ggsave()} will not
save images larger than 50x50 inches, to prevent the common error of
specifying dimensions in pixels.}

\item{device_ext}{file extension to use for images created. Does not usually need to be populated manually.}

\item{bg}{Background colour. If \code{NULL}, uses the \code{plot.background} fill value
from the plot theme.}

\item{name}{name of gif}

\item{first_image_duration}{n units of frame_duration to show the last image for}

\item{last_image_duration}{n units of frame_duration to show the last image for}

\item{frame_duration}{n seconds each plot should be shown}

\item{loop}{if the gif should be repeated. Set to FALSE to only play
once, or a number to indicate how many times to repeat after the first.}

\item{image_resize}{size to rescale images to in pixels}

\item{background}{color to set the background of the gif. A valid color string such as "navyblue" or
"#000080". Use "none" for transparency. Does not impact the background of images.}

\item{progress}{print some verbose status output}

\item{playback}{Boolean, should the recording start playing after it is
turned into a gif? defaults to TRUE}

\item{stoprecording}{Boolean, should the plots stop being recorded?
defaults to TRUE.}

\item{last_as_first}{Should the last plot be displayed at the beginning too?}

\item{...}{Other arguments passed on to the graphics device function,
as specified by \code{device}.}
}
\value{
Used initialize recording, nothing returned

Returns nothing. Used to generate the gif.

Returns the last plot generated, resized to new dimensions

Returns nothing. used for side effect.
}
\description{
Record plots created over time and generate a GIF of the plots
   made in the 'R' session. Overrides the print methods for ggplot and patchwork objects
   from the 'ggplot2' and 'patchwork' packages respectively.

resize the film for recording, reprints and saves last plot

Stop recording images with {camcorder}.
}
\section{Functions}{
\itemize{
\item \code{gg_playback()}: 

\item \code{gg_resize_film()}: 

\item \code{gg_stop_recording()}: 

}}
\examples{
 if(require(ggplot2) & interactive()){
  gg_record(dir = file.path(tempdir(),"recording"))
  ggplot(data.frame(x = 1, y = 1), aes(x=x, y=y)) + geom_point() + ylim(0,4)
  ggplot(data.frame(x = 1, y = 2), aes(x=x, y=y)) + geom_point() + ylim(0,4)

  ## resize canvas of the last plot
  gg_resize_film(height = 10, width = 5, dpi = 350)

  ggplot(data.frame(x = 1, y = 3), aes(x=x, y=y)) + geom_point() + ylim(0,4)

  gg_playback(tempfile(fileext = ".gif"))
}

}
