% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kid_class.R
\name{kid_class}
\alias{kid_class}
\title{Classification of childhood cancer.}
\usage{
kid_class(histology, site, method = "iccc3", depth = 1, verbose = FALSE)
}
\arguments{
\item{histology}{Histology code of the cancer.}

\item{site}{Site (aka topography) code of the cancer.}

\item{method}{Method to use for diagnosis classification.
Default is \code{"iccc3"}.
Can be one of \code{"iccc3"}, \code{"who-iccc3"}, \code{"iarc2017"}.}

\item{depth}{Depth level of the classification hierarchy to be determined.
If set to \code{99}, will return the SEER grouping.}

\item{verbose}{Logical value to print messages to the console if unable to
classify or duplicates found. Default is \code{FALSE}.}
}
\value{
Returns the diagnostic classification of the childhood cancer based on the specified
method and depth level.
}
\description{
Determines the type of childhood cancer cases based on the histology
and site codes of the cancer. It uses the International Classification of Childhood
Cancer (ICCC) codes to determine the classification. The function returns a value
based on the method specified and the depth level of the classification hierarchy
to be determined.
}
\examples{
kid_class("8522", "C50.1", method = "iccc3", depth = 1)

kid_class("8970", "C22.0", method = "iccc3", depth = 2)
}
