% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user_settings.R
\name{set_cansim_cache_path}
\alias{set_cansim_cache_path}
\title{Set persistent cansim cache location}
\usage{
set_cansim_cache_path(cache_path, overwrite = FALSE, install = FALSE)
}
\arguments{
\item{cache_path}{a local directory to use for saving cached data}

\item{overwrite}{Option to overwrite any existing cache path already stored locally.}

\item{install}{Option to install permanently for use across sessions.}
}
\description{
Cansim provides session caching for retrieved data. This function will create a persistent cache across sessions for data accessed via `get_cansim_connection` and caches data in a database across sessions..
}
\examples{
\dontrun{
set_cansim_cache_path("~/cansim_cache")

# This will set the cache path permanently until overwritten again
set_cansim_cache_path("~/cancensus_cache", install = TRUE)
}
}
