% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lin_alg_advanced.R
\name{do_la}
\alias{do_la}
\title{Do linear algebra operation}
\usage{
do_la(x, slot, ...)
}
\arguments{
\item{x}{A matrix for which a property is requested}

\item{slot}{The property requested}

\item{...}{Auxillary arguments}
}
\value{
Returns the requested property of a matrix.
}
\description{
Do linear algebra operation
}
\examples{
if (has_sympy()) {
  A <- matrix(c("a", "0", "0", "1"), 2, 2) \%>\% as_sym()
  
  do_la(A, "QR")
  QRdecomposition(A)

  do_la(A, "LU")
  LUdecomposition(A)

  do_la(A, "cholesky", hermitian = FALSE)
  chol(A, hermitian = FALSE)
  
  do_la(A, "singular_value_decomposition")
  do_la(A, "svd")
  svd_res <- svd_(A)
  svd_res
  U_expr <- svd_res$U |> as_expr()
  U_expr
  eval(U_expr, list(a = 3+2i))
  
  b <- symbol("b", real = TRUE)
  B <- matrix(c("b", "0", "0", "1"), 2, 2) \%>\% as_sym(declare_symbols = FALSE)
  svd_(B)

  do_la(A, "eigenval")
  eigenval(A)
  
  do_la(A, "eigenvec")
  eigenvec(A)
  
  do_la(A, "inv")
  inv(A)
  
  do_la(A, "trace")
  trace_(A)
  
  do_la(A, "echelon_form")
  do_la(A, "rank")
  
  do_la(A, "det") # Determinant
  det(A)
}

}
\concept{linalg}
