% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/household_emissions.R
\name{household_emissions}
\alias{household_emissions}
\title{Calculate household material emissions (vector-first)}
\usage{
household_emissions(
  paper_use = stats::setNames(numeric(), character()),
  plastic_use = stats::setNames(numeric(), character()),
  metal_use = stats::setNames(numeric(), character()),
  electrical_use = stats::setNames(numeric(), character()),
  construction_use = stats::setNames(numeric(), character()),
  paper_waste = TRUE,
  plastic_waste = TRUE,
  metal_waste = TRUE,
  electrical_waste = TRUE,
  construction_waste = TRUE,
  paper_material_production = "Primary material production",
  metal_material_production = "Primary material production",
  construction_material_production = "Primary material production",
  paper_waste_disposal = c("Closed-loop", "Combustion", "Composting", "Landfill"),
  plastic_waste_disposal = c("Landfill", "Open-loop", "Closed-loop", "Combustion"),
  metal_waste_disposal = c("Closed-loop", "Combustion", "Landfill", "Open-loop"),
  electrical_waste_disposal = c("Landfill", "Open-loop"),
  construction_waste_disposal = c("Closed-loop", "Combustion", "Composting", "Landfill",
    "Open-loop"),
  gcb_use = stats::setNames(numeric(), character()),
  gcb_waste = TRUE,
  gcb_waste_disposal = c("Closed-loop", "Combustion", "Landfill"),
  organic_use = stats::setNames(numeric(), character()),
  organic_waste = TRUE,
  compost_waste_disposal = c("Anaerobic digestion", "Combustion", "Composting",
    "Landfill"),
  household_residual_waste = 0,
  hh_waste_disposal = c("Combustion", "Landfill"),
  units = c("kg", "tonnes"),
  value_col = c("value", "value_2024"),
  strict = TRUE
)
}
\arguments{
\item{paper_use, plastic_use, metal_use, electrical_use, construction_use}{Named numeric vectors (tonnes) passed to the corresponding calculators.}

\item{paper_waste, plastic_waste, metal_waste, electrical_waste, construction_waste}{Logical; if \code{TRUE}, apply waste factors to the same tonnages as \verb{*_use}.}

\item{paper_material_production, metal_material_production, construction_material_production}{Single string or per-material named vector for MU column text; forwarded.}

\item{paper_waste_disposal, plastic_waste_disposal, metal_waste_disposal, electrical_waste_disposal, construction_waste_disposal}{Waste route per family; forwarded.}

\item{gcb_use}{Named numeric vector for Glass/Clothing/Books (keys: \code{glass}, \code{clothing}, \code{books}).
E.g., \code{gcb_use = c(glass = 3, books = 0.5)}}

\item{gcb_waste}{Logical; if \code{TRUE}, apply GCB waste factors to same tonnages.}

\item{gcb_waste_disposal}{One of \code{"Closed-loop"}, \code{"Combustion"}, \code{"Landfill"}.}

\item{organic_use}{Named numeric vector for \code{food}, \code{drink},
\code{compost_from_garden}, \code{compost_from_food_and_garden}.}

\item{organic_waste}{Logical; if \code{TRUE}, apply organic waste factors to same tonnages.}

\item{compost_waste_disposal}{One of \code{"Anaerobic digestion"}, \code{"Combustion"}, \code{"Composting"}, \code{"Landfill"}.}

\item{household_residual_waste}{Numeric (tonnes).}

\item{hh_waste_disposal}{\code{"Combustion"} or \code{"Landfill"}.}

\item{units}{Output units: \code{"kg"} (default) or \code{"tonnes"}.}

\item{value_col}{Which factor column in \code{uk_gov_data} to use: \code{"value"} or \code{"value_2024"}.}

\item{strict}{If \code{TRUE} (default) error when a required factor is missing; if \code{FALSE}, treat as 0.}
}
\value{
Numeric total emissions in requested \code{units}.
}
\description{
Sums emissions from paper, plastics, metals, electrical, construction
(delegated to their calculators) plus household-specific streams:
Glass/Clothing/Books (GCB), Organic (food/drink/compost), and
Household residual waste.
}
\section{Inputs}{

Provide named \verb{*_use} vectors in tonnes and \verb{*_waste = TRUE/FALSE} flags.
Unknown names in \code{gcb_use} / \code{organic_use} are ignored with a warning.
}

\examples{
household_emissions(
  gcb_use = c(glass = 3, books = 0.5),
  organic_use = c(food = 1, drink = 0.5),
  household_residual_waste = 0.8,
  gcb_waste = TRUE, organic_waste = TRUE,
  gcb_waste_disposal = "Closed-loop",
  compost_waste_disposal = "Anaerobic digestion",
  hh_waste_disposal = "Combustion",
  units = "kg"
)
}
