% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/office_emissions.R
\name{office_emissions}
\alias{office_emissions}
\title{Office emissions (uses building_emissions + homeworking factors)}
\usage{
office_emissions(
  specify = FALSE,
  office_num = 1,
  WFH_num = 0,
  WFH_hours = 0,
  WFH_type = c("Office Equipment", "Heating"),
  water_supply = 0,
  water_trt = TRUE,
  water_unit = c("cubic metres", "million litres"),
  electricity_kWh = 0,
  electricity_TD = TRUE,
  electricity_WTT = TRUE,
  heat_kWh = 0,
  heat_TD = TRUE,
  heat_WTT = TRUE,
  units = c("kg", "tonnes"),
  value_col = c("value", "value_2024"),
  strict = TRUE
)
}
\arguments{
\item{specify}{Logical. If \code{FALSE}, use an average per person; if \code{TRUE}, use
the specified utility inputs (water/electricity/heat) via \code{\link[=building_emissions]{building_emissions()}}.}

\item{office_num}{Number of individuals in the office (only used when \code{specify = FALSE}).
Uses a constant of \strong{2600 kg CO2e per person-year}.}

\item{WFH_num}{Number of people working from home.}

\item{WFH_hours}{Hours worked from home \strong{per person}.
If one of \code{WFH_num}/\code{WFH_hours} is zero but the other is > 0, the zero one is treated as 1.}

\item{WFH_type}{Which homeworking components to include; any of
\code{c("Office Equipment","Heating")}. Default is both.}

\item{water_supply}{See \code{\link[=building_emissions]{building_emissions()}}.}

\item{water_trt}{See \code{\link[=building_emissions]{building_emissions()}}.}

\item{water_unit}{See \code{\link[=building_emissions]{building_emissions()}}.}

\item{electricity_kWh, electricity_TD, electricity_WTT}{See \code{\link[=building_emissions]{building_emissions()}}.}

\item{heat_kWh, heat_TD, heat_WTT}{See \code{\link[=building_emissions]{building_emissions()}}.}

\item{units}{Output units: \code{"kg"} (default) or \code{"tonnes"}.}

\item{value_col}{Which factor column to use in \code{uk_gov_data}: \code{"value"} or \code{"value_2024"}.}

\item{strict}{If \code{TRUE} (default), error when needed factors (e.g., homeworking)
are missing. If \code{FALSE}, treat missing factors as 0.}
}
\value{
Numeric total emissions in requested \code{units}.
}
\description{
Computes office emissions either from a per-person average (when \code{specify = FALSE})
or from specified utilities via \code{\link[=building_emissions]{building_emissions()}} (when \code{specify = TRUE}),
plus optional \strong{homeworking} emissions (Level 1 = "Homeworking").
}
\details{
Factors are assumed \strong{kg CO2e per unit} (e.g., per person-hour for homeworking),
and the result is returned in requested \code{units}.
}
\examples{
# 1) Use specified utilities (building_emissions) + homeworking
office_emissions(
  specify = TRUE,
  electricity_kWh = 200, heat_kWh = 100,
  water_supply = 10, water_unit = "cubic metres",
  WFH_num = 5, WFH_hours = 8, WFH_type = c("Office Equipment","Heating")
)

# 2) Use per-person average for 12 staff, with WFH equipment only
office_emissions(
  specify = FALSE, office_num = 12,
  WFH_num = 6, WFH_hours = 4, WFH_type = "Office Equipment",
  units = "tonnes"
)
}
