% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuel_and_co2.R
\name{fuel_cons_harvester_1}
\alias{fuel_cons_harvester_1}
\title{Fuel Consumption of a Harvester per Cubic Meter Harvested Wood (Version #1)}
\usage{
fuel_cons_harvester_1(tree_vol, tree_dbh)
}
\arguments{
\item{tree_vol}{Average standing merchandable wood volume over bark (m³) per
harvested tree}

\item{tree_dbh}{Average diameter at breast height (cm) per harvested tree}
}
\value{
Fuel consumption of a harvester in liters diesel fuel per m³
harvested wood
}
\description{
Fuel consumption depends on the average tree volume. For tree diameters at
breast height < 15 cm the function gives back \code{NA}, because the assumed
machine does not work with such small trees. Estimated after
\insertCite{Bacescu_et_al_2022;textual}{care4cmodel}.
}
\examples{
  dbh <- seq(10, 70, 10) # Vector of tree dbh in cm
  vol <- dbh ^ 2 / 1000  # Simple Volume estimate (m³) with Denzin's formula

  fuel_cons_harvester_1(vol, dbh)

}
\references{
\insertRef{Bacescu_et_al_2022}{care4cmodel}
}
