% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/background-color.R
\name{background_color}
\alias{background_color}
\alias{background_subtle}
\title{Change background color}
\usage{
background_color(x, color)

background_subtle(x, color)
}
\arguments{
\item{x}{A tag element or \link{.style} pronoun.}

\item{color}{A character string specifying a color. One of,
\itemize{
\item \code{"primary"}
\item \code{"secondary"}
\item \code{"success"}
\item \code{"danger"}
\item \code{"warning"}
\item \code{"info"}
\item \code{"light"}
\item \code{"dark"}
}}
}
\value{
An object of the same type as \code{x}.
}
\description{
The \code{background_color()} and \code{background_subtle()} functions adjust the
background color of a tag element.
}
\examples{

library(htmltools)

div(
  .style \%>\%
    background_color(theme_primary()),
  "Primary background"
)

div(
  .style \%>\%
    background_color(theme_danger()),
  "Danger background"
)

div(
  .style \%>\%
    background_subtle(theme_warning()) \%>\%
    border_subtle(theme_warning()) \%>\%
    text_emphasis(theme_warning()),
  "Warning!"
)


div(
  .style \%>\%
    background_subtle(theme_dark()) \%>\%
    border_subtle(theme_dark())
)

}
