% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flex-content.R
\name{flex_content}
\alias{flex_content}
\title{Flex content}
\usage{
flex_content(x, ...)
}
\arguments{
\item{x}{A tag element or \link{.style} pronoun.}

\item{...}{A character string specifying the cross axis alignment. One of,
\itemize{
\item \code{"start"}
\item \code{"end"}
\item \code{"center"}
\item \code{"between"}
\item \code{"around"}
\item \code{"stretch"}

Use name-value pairs to specify \link{breakpoints}.
}}
}
\value{
An object of the same type as \code{x}.
}
\description{
The \code{flex_content()} function adjusts how a tag element's child elements
align as a group on the cross axis (see \code{\link[=flex_justify]{flex_justify()}} for more info about
the main and cross axis of a flex element). Note, this alignment has no
effect on a single row of child elements.
}
\examples{

library(htmltools)

div(
  .style \%>\%
    flex_display() \%>\%
    flex_content("center") \%>\%
    flex_wrap(TRUE),
  div("Flex item"),
  div("Flex item"),
  div("Flex item"),
  div("Flex item"),
  div("Flex item")
)
}
\seealso{
Other flex utilities: 
\code{\link{flex_align}()},
\code{\link{flex_direction}()},
\code{\link{flex_display}()},
\code{\link{flex_justify}()},
\code{\link{flex_wrap}()},
\code{\link{item_align}()},
\code{\link{item_fill}()},
\code{\link{item_grow}()},
\code{\link{item_order}()}
}
\concept{flex utilities}
