% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text-weight.R
\name{text_weight}
\alias{text_weight}
\title{Text weight}
\usage{
text_weight(x, weight)
}
\arguments{
\item{x}{A tag element or \link{.style} pronoun.}

\item{weight}{A character string specifying the font weight. One of,
\itemize{
\item \code{"bold"}
\item \code{"bolder"}
\item \code{"semibold"}
\item \code{"medium"}
\item \code{"normal"}
\item \code{"light"}
\item \code{"lighter"}

\code{"bolder"} and \code{"lighter"} change the font weight relative to the current
font weight.
}}
}
\value{
An object of the same type as \code{x}.
}
\description{
The \code{text_weight()} function adjusts the font weight of a tag element.
}
\examples{

library(htmltools)

p(
  .style \%>\%
    text_weight("bold"),
  "Bold"
)

p(
  .style \%>\%
    text_weight("light"),
  "Light"
)

}
\seealso{
Other text utilities: 
\code{\link{text_alignment}()},
\code{\link{text_break}()},
\code{\link{text_color}()},
\code{\link{text_decoration}()},
\code{\link{text_height}()},
\code{\link{text_selection}()},
\code{\link{text_style}()},
\code{\link{text_transform}()},
\code{\link{text_wrap}()}
}
\concept{text utilities}
