#' Breast Cancer Wisconsin (Diagnostic) Data Set
#'
#' Dataset documentation can be found at the source website and references below.
#'
#' @details
#' The ID variable was removed.
#' Diagnosis (1= malignant, 0 = benign).
#' Feature variables have been renamed.
#'
#' @format ## `data_wdbc`
#' A data frame with 569 rows (patients) and 31 columns (1 target, 30 features).
#'
#' @references
#' - W.N. Street, W.H. Wolberg and O.L. Mangasarian. Nuclear feature extraction for breast tumor diagnosis. IS&T/SPIE 1993 International Symposium on Electronic Imaging: Science and Technology, volume 1905, pages 861-870, San Jose, CA, 1993.
#' - O.L. Mangasarian, W.N. Street and W.H. Wolberg. Breast cancer diagnosis and prognosis via linear programming. Operations Research, 43(4), pages 570-577, July-August 1995.
#' @source <https://archive.ics.uci.edu/ml/datasets/breast+cancer+wisconsin+(diagnostic)>
"data_wdbc"
