% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap_helpers.r
\name{generate_replicate_results}
\alias{generate_replicate_results}
\alias{generate_replicate_results_dplyr}
\title{Compute bootstrapping results}
\usage{
generate_replicate_results(
  base_compare,
  n_bt,
  grouping_var,
  seed = NULL,
  ps_flags = list(intermed = FALSE, summarise = FALSE),
  label_distribution = NULL,
  cost_fp = NULL,
  replace_zero_division_with = options::opt("replace_zero_division_with"),
  drop_empty_groups = options::opt("drop_empty_groups"),
  progress = options::opt("progress")
)

generate_replicate_results_dplyr(
  base_compare,
  n_bt,
  grouping_var,
  seed = NULL,
  label_distribution = NULL,
  ps_flags = list(intermed = FALSE, summarise = FALSE),
  cost_fp = NULL,
  progress = FALSE
)
}
\arguments{
\item{base_compare}{A data.frame as generated by \code{create_comparison}.}

\item{n_bt}{An integer number of resamples to be used for bootstrapping.}

\item{grouping_var}{A character vector of variables that must be present in
\code{base_compare}.}

\item{seed}{A seed passed to resampling step for reproducibility.}

\item{ps_flags}{A list as returned by \code{set_ps_flags}.}

\item{label_distribution}{Expects a data.frame with columns \code{"label_id",
  "label_freq", "n_docs"}. \code{label_freq} corresponds to the number of
occurences a label has in the gold standard. \code{n_docs} corresponds to
the total number of documents in the gold standard.}

\item{cost_fp}{A numeric value > 0, defaults to NULL.}

\item{replace_zero_division_with}{In macro averaged results (doc-avg, subj-avg), it may occur that some
instances have no predictions or no gold standard. In these cases,
calculating precision and recall may lead to division by zero. CASIMiR
standardly removes these missing values from macro averages, leading to a
smaller support (count of instances that were averaged). Other
implementations of macro averaged precision and recall default to 0 in these
cases. This option allows to control the default. Set any value between 0
and 1. (Defaults to \code{NULL}, overwritable using option 'casimir.replace_zero_division_with' or environment variable 'R_CASIMIR_REPLACE_ZERO_DIVISION_WITH')}

\item{drop_empty_groups}{Should empty levels of factor variables be dropped in grouped set retrieval
computation? (Defaults to \code{TRUE}, overwritable using option 'casimir.drop_empty_groups' or environment variable 'R_CASIMIR_DROP_EMPTY_GROUPS')}

\item{progress}{Display progress bars for iterated computations (like bootstrap CI or
pr curves). (Defaults to \code{FALSE}, overwritable using option 'casimir.progress' or environment variable 'R_CASIMIR_PROGRESS')}
}
\value{
A data.frame containing \code{n_bt} boot replica of results as
returned by \code{compute_intermediate_results} and
\code{summarise_intermediate_results}.
}
\description{
Wrapper for computing \code{n_bt} bootstrap replica, combining the
functionality of \code{compute_intermediate_results} and
\code{summarise_intermediate_results}.
}
\section{Functions}{
\itemize{
\item \code{generate_replicate_results_dplyr()}: Variant with dplyr based
internals rather than collapse internals.

}}
