% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate.R
\name{calc_scags_wide}
\alias{calc_scags_wide}
\title{Compute scagnostics on all possible scatter plots for the given data}
\usage{
calc_scags_wide(
  all_data,
  scags = c("outlying", "stringy", "striated", "striated2", "clumpy", "clumpy2",
    "sparse", "skewed", "convex", "skinny", "monotonic", "splines", "dcor"),
  out.rm = TRUE,
  euclid = FALSE
)
}
\arguments{
\item{all_data}{tibble of multivariate data on which to compute scagnostics}

\item{scags}{collection of strings matching names of
scagnostics to calculate: outlying, stringy, striated,
striated2, striped, clumpy, clumpy2, sparse, skewed, convex,
skinny, monotonic, splines, dcor}

\item{out.rm}{logical indicator to indicate if outliers should be removed before calculating non outlying measures}

\item{euclid}{logical indicator to use Euclidean distance}
}
\value{
A data frame that gives the data's scagnostic scores for each possible variable combination.
}
\description{
Compute scagnostics on all possible scatter plots for the given data
}
\examples{
# Calculate selected scagnostics
data(pk)
calc_scags_wide(pk[,2:5], scags=c("outlying","monotonic"))

}
\seealso{
calc_scags
}
