% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mst.R
\name{sc_sparse}
\alias{sc_sparse}
\alias{sc_sparse.default}
\alias{sc_sparse.scree}
\alias{sc_sparse.igraph}
\title{Compute sparse scagnostic measure using MST}
\usage{
sc_sparse(x, y)

\method{sc_sparse}{default}(x, y)

\method{sc_sparse}{scree}(x, y = NULL)

\method{sc_sparse}{igraph}(x, y)
}
\arguments{
\item{x}{numeric vector of x values}

\item{y}{numeric vector of y values}
}
\value{
A "numeric" object that gives the plot's sparse score.
}
\description{
Compute sparse scagnostic measure using MST
}
\examples{
  require(ggplot2)
  require(tidyr)
  require(dplyr)
  ggplot(datasaurus_dozen, aes(x=x, y=y)) +
    geom_point() +
    facet_wrap(~dataset, ncol=3, scales = "free")
  sc_sparse(datasaurus_dozen_wide$away_x, datasaurus_dozen_wide$away_y)
  sc_sparse(datasaurus_dozen_wide$circle_x, datasaurus_dozen_wide$circle_y)
  sc_sparse(datasaurus_dozen_wide$dino_x, datasaurus_dozen_wide$dino_y)

}
