% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{get_cox_gradient}
\alias{get_cox_gradient}
\title{Compute the Gradient for Cox Proportional Hazards Model}
\usage{
get_cox_gradient(X, time, status, coefs, entry_points)
}
\arguments{
\item{X}{A matrix of covariates (design matrix) for the Cox model.}

\item{time}{A numeric vector of event times.}

\item{status}{A numeric vector of event indicators (1 for event, 0 for censored).}

\item{coefs}{A numeric vector of coefficients for the Cox model.}

\item{entry_points}{A numeric vector of entry times for the subjects. Defaults to 0.}
}
\value{
A numeric vector representing the gradient of the Cox proportional hazards model.
}
\description{
This function computes the gradient for the Cox proportional hazards model. The gradient
is calculated by considering the contributions of each observation to the gradient based on the
risk set at each event time.
}
