% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{get_cox_syn_hessian}
\alias{get_cox_syn_hessian}
\title{Compute the Synthetic Hessian Matrix for Cox Proportional Hazards Model}
\usage{
get_cox_syn_hessian(X, time, coefs, hazard_constant)
}
\arguments{
\item{X}{A matrix of covariates (design matrix) for the Cox model.}

\item{time}{A numeric vector of event times.}

\item{coefs}{A numeric vector of coefficients for the Cox model.}

\item{hazard_constant}{A numeric value representing the hazard constant.}
}
\value{
A matrix representing the synthetic Hessian of the Cox model.
}
\description{
This function computes the synthetic Hessian matrix for the Cox proportional hazards model.
The Hessian is calculated by summing the contributions from each individual observation, scaled by
the hazard constant and the time of the event.
}
