% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{idata}
\alias{idata}
\title{Synthetic Data for illustrating optimal treatment regimes and individualized effects}
\format{
A data frame containing the following variables. The data are provided only for
explanatory purposes.
\describe{
\item{Y:}{ A continuous outcome variable.}
\item{R:}{ A binary group indicator with a value of 0 (reference) and 1 (comparison).}
\item{M:}{ A binary risk factor with a value of 0 (not treated/received) and 1(treated/received).}
\item{X1:}{ First continuous intermediate confounder.}
\item{X2:}{ Second continuous intermediate confounder.}
\item{X3:}{ Third continuous intermediate confounder.}
\item{C:}{ A continuous baseline covariate.}
}
}
\usage{
idata
}
\description{
A randomly generated dataset containing 2000 cases 7 columns with no missing values.
The intermediate confounders are assumed to be independent of each other.
}
\details{
Note that all the variables are randomly generated using the simulation setting
in Park, S., Kang, S., & Lee, C. (2025).
}
\references{
Park, S., Kang, S., & Lee, C. (2025). Simulation-Based Sensitivity Analysis in
Optimal Treatment Regimes and Causal Decomposition with Individualized Interventions.
arXiv preprint arXiv:2506.19010.
}
\keyword{datasets}
