% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simGausFromDAG.R
\name{simGausFromDAG}
\alias{simGausFromDAG}
\title{Simulate Gaussian data according to DAG}
\usage{
simGausFromDAG(
  amat,
  n,
  regparLim = c(0.5, 2),
  resSDLim = c(0.1, 1),
  pnegRegpar = 0.4,
  standardize = FALSE
)
}
\arguments{
\item{amat}{An adjacency matrix.}

\item{n}{The number of observations that should be simulated.}

\item{regparLim}{The interval from which regression parameters are
sampled.}

\item{resSDLim}{The interval from which residual standard deviations
are sampled.}

\item{pnegRegpar}{The probability of sampling a negative regression
parameter.}

\item{standardize}{If \code{FALSE} (the default), the raw data are
returned. If \code{TRUE}, the data are first standardized, i.e.,
each variable will have its mean subtracted and be divided by its
standard deviation.}
}
\value{
A data.frame of identically distributed simulated observations.
}
\description{
Simulates a jointly Gaussian dataset given a DAG
adjacency matrix. The data is simulated using linear structural
equations and the parameters (residual standard deviations and
regression coefficients) are sampled from chosen intervals.
}
\details{
A variable \eqn{X_{i}} is simulated as \cr
\eqn{X_{i} := \sum_{Z \in pa(X_{i})} \beta_{Z} * Z + e_{i}} \cr
where \eqn{pa(X_{i})} are the parents of \eqn{X_{i}} in the DAG.
The residual, \eqn{e_{i}}, is drawn from a normal distribution.
}
