% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testmedident.R
\name{testmedident}
\alias{testmedident}
\title{Test for identification in causal mediation and dynamic treatment models}
\usage{
testmedident(
  y,
  d,
  m = NULL,
  x,
  w = NULL,
  z1,
  z2 = NULL,
  testmediator = TRUE,
  seed = 123,
  MLmethod = "lasso",
  k = 3,
  zeta_sigma = min(0.5, 500/length(y))
)
}
\arguments{
\item{y}{Outcome variable.}

\item{d}{Treatment variable.}

\item{m}{Mediator variable (optional).}

\item{x}{Baseline covariates (prior to treatment assignment).}

\item{w}{Post-treatment covariates (prior to mediator assignment, optional).}

\item{z1}{Instrument for the treatment.}

\item{z2}{Instrument for the mediator (optional).}

\item{testmediator}{Logical indicating if the mediator should be used as dependent variable (in addition to outcome \code{y}) when testing if the effect of treatment \code{d} is identified. Default is TRUE.}

\item{seed}{Random seed for sample splitting in cross-fitting. Default is 123.}

\item{MLmethod}{Machine learning method for estimating conditional outcome/mediator means required for testing. Default is "lasso".}

\item{k}{Number of cross-fitting folds. Default is 3.}

\item{zeta_sigma}{Tuning parameter defining the standard deviation of a random, mean zero, and normal variable that is added to the test statistic to avoid a degenerate distribution of test statistic under the null hypothesis. \code{zeta_sigma} gauges the trade-off between power and size of the test. Default is the minimum of 0.5 and 500/(# of observations).}
}
\value{
A list with the following components:
\item{teststat}{Test statistic.}
\item{se}{Standard error of the test statistic.}
\item{pval}{Two-sided p-value of the test.}
}
\description{
This function tests for identification in causal mediation and dynamic treatment models based on covariates and instrumental variables using machine learning methods.
}
\details{
This function implements a hypothesis test for identifying causal effects in mediation and dynamic treatment models involving sequential assignment of treatment and mediator variables. The test jointly verifies the exogeneity/ignorability of treatment and mediator variables conditional on covariates and the validity of (distinct) instruments for the treatment and mediator (ignorability of instrument assignment and exclusion restriction). If the null hypothesis holds, dynamic and pathwise causal effects may be identified based on the sequential exogeneity/ignorability of the treatment and the mediator given the covariates. The function employs machine learning techniques to control for covariates in a data-driven manner.
}
\examples{
\dontrun{
# Example with simulated data in which null hypothesis holds
n=2000
x=rnorm(n)
z1=rnorm(n)
z2=rnorm(n)
d=1*(0.5*x+0.5*z1+rnorm(n)>0)      # Treatment equation
m=0.5*x+0.5*d+0.5*z2+rnorm(n)      # Mediator equation
y=0.5*x+d+0.5*m+rnorm(n)           # Outcome equation
# Run test and report p-value
testmedident(y=y, d=d, m=m, x=x, z1=z1, z2=z2)$pval
}
}
\references{
Huber, M., Kloiber, K., and Lafférs, L. (2024): "Testing identification in mediation and dynamic treatment models", arXiv preprint 2406.13826.
}
