% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_design.R
\name{validate_design_object}
\alias{validate_design_object}
\title{Validate and potentially reconstruct a CBC design object}
\usage{
validate_design_object(data, require_class = FALSE, allow_choices = TRUE)
}
\arguments{
\item{data}{Input data (cbc_design, cbc_choices, or data.frame)}

\item{require_class}{Logical. If TRUE, strictly requires proper class. If FALSE,
allows data.frames with correct structure.}

\item{allow_choices}{Logical. If TRUE, allows cbc_choices objects. Default TRUE.}
}
\value{
A list with: valid (logical), data (potentially reconstructed),
message (character or NULL)
}
\description{
This internal function checks if data is a valid CBC design/choices object
or can be treated as one. If the data has lost its class but has the right
structure (ID columns), it attempts to reconstruct minimal attributes.
}
\keyword{internal}
