% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alt_SAR.R
\name{SparseCCA}
\alias{SparseCCA}
\title{Function to perform Sparse CCA based on Wilms and Croux (2018)
REFERENCE Wilms, I., & Croux, C. (2018). Sparse canonical correlation analysis using alternating regressions. Journal of Computational and Graphical Statistics, 27(1), 1-10.}
\usage{
SparseCCA(
  X,
  Y,
  lambdaAseq = seq(from = 1, to = 0.01, by = -0.01),
  lambdaBseq = seq(from = 1, to = 0.01, by = -0.01),
  rank,
  selection.criterion = 1,
  n.cv = 5,
  A.initial = NULL,
  B.initial = NULL,
  max.iter = 20,
  conv = 10^-2,
  standardize = TRUE
)
}
\arguments{
\item{X}{Matrix of predictors (n x p)}

\item{Y}{Matrix of responses (n x q)}

\item{lambdaAseq}{Vector of sparsity parameters for X (default is a sequence from 0 to 1 with step 0.1)}

\item{lambdaBseq}{Vector of sparsity parameters for Y (default is a sequence from 0 to 1 with step 0.1)}

\item{rank}{Number of canonical components to extract}

\item{selection.criterion}{Criterion for selecting the optimal tuning parameter (1 for minimizing difference between test and training sample correlation, 2 for maximizing test sample correlation)}

\item{n.cv}{Number of cross-validation folds (default is 5)}

\item{A.initial}{Initial value for the canonical vector A (default is NULL, which uses a canonical ridge solution)}

\item{B.initial}{Initial value for the canonical vector B (default is NULL, which uses a canonical ridge solution)}

\item{max.iter}{Maximum number of iterations for convergence (default is 20)}

\item{conv}{Convergence threshold (default is 1e-2)}

\item{standardize}{Standardize (center and scale) the data matrices X and Y (default is TRUE) before analysis}
}
\value{
A list with elements:
\describe{
\item{U}{Canonical direction matrix for X (p x r)}
\item{V}{Canonical direction matrix for Y (q x r)}
\item{loss}{Mean squared error of prediction}
\item{cor}{Canonical covariances}
}
}
\description{
Function to perform Sparse CCA based on Wilms and Croux (2018)
REFERENCE Wilms, I., & Croux, C. (2018). Sparse canonical correlation analysis using alternating regressions. Journal of Computational and Graphical Statistics, 27(1), 1-10.
}
